/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: DriverLayerLibUsb.h                                                *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              24/05/2007       1.0                              *
* Carlos Grossy              15/06/2007       1.1                              *
*******************************************************************************/

#ifndef _DRIVERLAYERLIBUSB_H_
#define _DRIVERLAYERLIBUSB_H_

#ifdef _DRIVER_LIBUSB

using namespace std;
#include <map>
#include <usb.h>
#include "DriverLayer.h"
#include "PlatformLayerLinux.h"

typedef struct {
    int serial;
    int qtyep;
    struct usb_dev_handle *devhnd;
    dscEndpoint eps[15];
} itemBoard;

class driverLayerLibUsb : public driverLayer {
    private:
        map<int,itemBoard> boards;
        int explenrecv;
        int pid;
        int vid;
        void findU4ABoards();
        struct usb_dev_handle* getInstance(int);
        int unBuildBoardPart(int);
        int unBuildDscPart(int);
        platformLayerLinux * pl;
    public:
        driverLayerLibUsb();
        ~driverLayerLibUsb();
        // Inicializacion
        int* getU4ABoards(int&);
        int qtyDsc(int);
        dscEndpoint* getEndpointDsc(int, int);
        // Utilizacion
        int open(int, int, usbin);
        int open(int, int, usbout);
        bool close(int);
        bool sendInt(int, char *, int, int);
        bool sendCtrl(int, char*, int, int);
        bool sendIso(int, char*, int, int);
        bool sendBulk(int, char*, int, int);
        char* receiveInt(int, int&, bool&, int);
        char* receiveCtrl(int, int&, bool&, int);
        char* receiveIso(int, int&, bool&, int);
        char* receiveBulk(int, int&, bool&, int);
};

#endif

#endif
